<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vacios extends Model 
{

    protected $table = 'vacios';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'tipo', 'matricula', 'parking', 'notes', 'complete');
    protected $visible = array('client_id', 'tipo', 'matricula', 'parking', 'notes', 'complete');

    public function client()
    {
        return $this->belongsTo('Client');
    }

}